import {packFromDatabaseT} from "../../../src/types/pack";

export default function createDefaultPack(props: Partial<packFromDatabaseT>):packFromDatabaseT {

    const {
        name,
        author = "Videolancer",
        badgeBackgroundColor,
        badgeText,
        badgeTextColor,
        cover,
        for: forEnv,
        iiv,
        isMissingInFolder,
        isVerified,
        iv,
        motionBroSfxPack,
        motionBroSfxCompatible,
        motionBroSfxDefault,
        packFolderName,
        path,
        rootDir,
        thumbnail,
        type,
        uv,
        version,
        vv,
    }
        = props


    return {
        assetsFolder: `D:\\temp\\MotionBro\\${name}_by_${author}\\(Assets)`,
        author: author || "Videolancer",
        badgeBackgroundColor: badgeBackgroundColor || undefined,
        badgeText: badgeText || undefined,
        badgeTextColor: badgeTextColor || undefined,
        cover: cover || undefined, // ToDo сделать чтобы можно было указывать путь к файлу
        for: forEnv || ["AE", "PP"],
        iiv: iiv || false,
        isMissingInFolder: isMissingInFolder || false,
        isVerified: isVerified || 1,
        iv: iv || "1",
        motionBroSfxPack: motionBroSfxPack || undefined,
        motionBroSfxCompatible: motionBroSfxCompatible || undefined,
        motionBroSfxDefault: motionBroSfxDefault || null,
        name: name || "Pack",
        packFolderName: packFolderName || `${name}_by_${author}`,
        path: path || `D:\\temp\\MotionBro\\${name}_by_${author}\\pack.json`,
        rootDir: rootDir || `D:\\temp\\MotionBro\\${name}_by_${author}`,
        thumbnail: thumbnail || undefined,
        type: type || "pack",
        uv: uv || null,
        version: version || "1.0.1",
        vv: vv || false,
    }
}